%% Quantization noise power spectrum

% This code generates Fig2b

clear all
close all
clc

load('Fig2b_-15.mat')

figure
% set(gca,'FontSize',18) 
plot((aoa_grid), 10*log10(q_noise), 'r-.','LineWidth',2)
hold on

load('Fig2b_0.mat')
plot((aoa_grid), 10*log10(q_noise), 'b','LineWidth',2)
hold on

load('Fig2b_15.mat')
plot((aoa_grid), 10*log10(q_noise), '--','LineWidth',2,'color',[0.8500, 0.3250, 0.0980])
grid on
legend('\psi = -15^0', '\psi = 0^0', '\psi = 15^0');
xlabel('Angle of arrival (degrees)')
ylabel('Quantization noise power (dB)')
legend('location','north')
%set(gca,'FontSize',20) 

legend boxoff

savefig('Fig2b.fig')
saveas(gcf,'Fig2b','epsc')